<?php

namespace frontend\controllers;

use Yii;
use frontend\models\Leads;
use frontend\models\LeadsSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\filters\AccessControl;
use yii\data\ActiveDataProvider;
/**
 * LeadsController implements the CRUD actions for Leads model.
 */
class LeadsController extends Controller
{
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'access' => [
                'class' => AccessControl::className(),
                //'only' => ['create','index'],
                'rules' => [
                     
                    [
                        'actions' => ['create','back'],
                        'allow' => true,
                        'roles' => ['?'],
                    ],
                    [
                        'actions' => ['index'],
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                ],
            ],
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'logout' => ['post'],
                ],
            ],
        ];
    }

    /**
     * Lists all Leads models.
     * @return mixed
     */
    public function actionIndex()
    {
        $searchModel = new LeadsSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single Leads model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id)
    {

        return $this->render('view', [
            'model' => $this->findModel($id),
        ]);
    }
 public function actionClose()
    {
         $this->layout = "blank";
        return $this->render('close');
    }
    /**
     * Creates a new Leads model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $this->layout = "combnew";
        $model = new Leads();

        if ($model->load(Yii::$app->request->post()) ) {
           $exist_lead=Leads::findOne(['contact_no' => $model->contact_no]);
           $count_lead=count($exist_lead);
            if($count_lead > 0) 
            {
                return $this->redirect(['leads/create','msg' => 1]);
            } 
               // exit;
             else {
            if($model->save())
                {
            // Send Notification to admin - on Whatsapp //
             $sendMsg="New user has submitted informaion successfully on combtechnologies site. Details - \r\n Person Name -".$model->person_name."\r\n Salon Name- ".$model->salon_name."\r\n Contact No- ".$model->contact_no;
             $whatsapp_key="60f8290c6ac9583c92671188";  // Petal touch whatsapp key
             $admin_contact_no="9850411116"; // Sachin Kale contact No.
             $this->sendWhatsapp($sendMsg, $whatsapp_key, $admin_contact_no);
 
             $url='http://combtechnologies.com/index_success.html';
               return $this->redirect($url);
             //return $this->redirect(['leads/close']);
                }
            }
            }

        return $this->render('create', [
            'model' => $model,
        ]);
    }

    /**
     * Updates an existing Leads model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'id' => $model->id]);
        }

        return $this->render('update', [
            'model' => $model,
        ]);
    }

    /**
     * Deletes an existing Leads model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id)
    {
        $this->findModel($id)->delete();

        return $this->redirect(['index']);
    }

     public function actionBack(){
        $url='http://combtechnologies.com/';
       return $this->redirect($url);
      }
    /**
     * Finds the Leads model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Leads the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Leads::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }


     public function sendWhatsapp($message,$whatsapp_key,$admin_contact_no)
    {
         $curl = curl_init();
       //  echo "doing curl call <br/>";
     $whatsapp_url="https://apiwhatsapp.transgosms.com/api/sendText?token=$whatsapp_key&phone=91".$admin_contact_no."&message=". urlencode($message);

curl_setopt_array($curl, array(
  CURLOPT_URL => $whatsapp_url,
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_ENCODING => "",
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 30,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => "GET",
 
));

$response = curl_exec($curl);
$err = curl_error($curl);
// echo "done curl call <br/> res: $response <br/>";
curl_close($curl);

if ($err) {
  return "cURL Error #:" . $err;
} else {
  return $response;
}
    }
}
