<?php

namespace frontend\models;

use Yii;

/**
 * This is the model class for table "coupon_codes".
 *
 * @property int $id
 * @property string $coupon_code
 * @property string $expiry_date
 * @property int $period
 * @property string $created_at
 */
class CouponCodes extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'coupon_codes';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['coupon_code', 'expiry_date', 'period', 'created_at'], 'required'],
            [['expiry_date', 'created_at'], 'safe'],
            [['period'], 'integer'],
            [['coupon_code'], 'string', 'max' => 200],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'coupon_code' => 'Coupon Code',
            'expiry_date' => 'Expiry Date',
            'period' => 'Period',
            'created_at' => 'Created At',
        ];
    }
}
