<?php

namespace frontend\models;

use Yii;

/**
 * This is the model class for table "leads".
 *
 * @property int $id
 * @property string $person_name
 * @property string $salon_name
 * @property string $salon_address
 * @property string $email_id
 * @property string $contact_no
 * @property int $team_size
 * @property string $website
 */
class Leads extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'leads';
    }

    /**
     * {@inheritdoc}
     */
     public $captcha;
    public function rules()
    {
        return [
            [['person_name', 'salon_name', 'salon_address', 'email_id', 'contact_no', 'team_size'], 'required'],
            [['team_size'], 'integer'],
            [['salon_address'], 'string'],
            [['person_name', 'salon_name'], 'string', 'max' => 255],
            [['email_id', 'website'], 'string', 'max' => 150],
            [['contact_no'], 'string', 'max' => 25],
            ['captcha','captcha'],
           
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'person_name' => 'Person Name',
            'salon_name' => 'Salon Name',
            'salon_address' => 'Salon Address',
            'email_id' => 'Email ID',
            'contact_no' => 'Contact No',
            'team_size' => 'Team Size',
            'website' => 'Website',
        ];
    }
}
