<?php

namespace frontend\models;

use Yii;

/**
 * This is the model class for table "user".
 *
 * @property int $id
 * @property string $first_name
 * @property string $last_name
 * @property string $username
 * @property string $email
 * @property string $address
 * @property string $organization_name
 * @property int $subscription_type
 * @property string $gst_no
 * @property string $gst_percent
 * @property string $sms_key
 * @property string $imagePath
 * @property string $contact_no
 * @property int $status
 * @property string $auth_key
 * @property string $password_hash
 * @property string $password_reset_token
 * @property string $verification_token
 * @property string $database_name
 * @property int $created_at
 * @property int $updated_at
 */
class User extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'user';
    }

    /**
     * {@inheritdoc}
     */
    public $captcha;
    public $user_password;
    public function rules()
    {
        return [
            [['first_name', 'email', 'organization_name', 'auth_key', 'password_hash', 'created_at', 'updated_at'], 'required'],
            [['subscription_type', 'status', 'created_at', 'updated_at'], 'integer'],
            [['first_name', 'last_name', 'organization_name', 'imagePath', 'database_name'], 'string', 'max' => 200],
            [['username', 'email', 'address', 'password_hash', 'password_reset_token', 'verification_token','ip_address','user_agent'], 'string', 'max' => 255],
            [['gst_no'], 'string', 'max' => 150],
            [['gst_percent'], 'string', 'max' => 11],
            [['sms_key'], 'string', 'max' => 250],
            [['contact_no'], 'string', 'max' => 10],
            [['auth_key'], 'string', 'max' => 32],
           // [['username'], 'unique'],
            [['email'], 'unique'],
            [['password_reset_token'], 'unique'],
            ['self_register','integer'],
            ['coupon_code', 'string', 'max' => 100],
            ['branch_id','integer'],
            ['branch_name', 'string', 'max' => 250],
            ['captcha','captcha'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'first_name' => 'First Name',
            'last_name' => 'Last Name',
            'username' => 'Username',
            'email' => 'Email',
            'address' => 'Address',
            'organization_name' => 'Organization Name',
            'subscription_type' => 'Subscription Type',
            'gst_no' => 'Gst No',
            'gst_percent' => 'Gst Percent',
            'sms_key' => 'Sms Key',
            'imagePath' => 'Image Path',
            'contact_no' => 'Contact No',
            'status' => 'Status',
            'auth_key' => 'Auth Key',
            'password_hash' => 'Password Hash',
            'password_reset_token' => 'Password Reset Token',
            'verification_token' => 'Verification Token',
            'database_name' => 'Database Name',
            'self_register' => 'Self Register',
            'coupon_code' => 'Coupon Code',
            'branch_name' => 'Branch Name',
            'created_at' => 'Created At',
            'updated_at' => 'Updated At',
        ];
    }
}
