<?php

/* @var $this \yii\web\View */
/* @var $content string */

use yii\helpers\Html;
use yii\bootstrap\Nav;
use yii\bootstrap\NavBar;
use yii\widgets\Breadcrumbs;
use frontend\assets\AppAsset;
use common\widgets\Alert;

AppAsset::register($this);
?>
<?php $this->beginPage() ?>
<!DOCTYPE html>
<html lang="<?= Yii::$app->language ?>">
<head>
    <meta charset="<?= Yii::$app->charset ?>">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <?php $this->registerCsrfMetaTags() ?>
    <title><?= Html::encode($this->title) ?></title>
    <?php $this->head() ?>
</head>
<body>
<?php $this->beginBody() ?>

<div class="wrap">
    <?php
    NavBar::begin([
        //'brandLabel' => Yii::$app->name,
        'brandLabel' => 'Sisems',
        'brandUrl' => 'http://sisems.com/',
        'options' => [
            'class' => 'navbar-inverse navbar-fixed-top',
        ],
    ]);
    $menuItems = [
        ['label' => 'Signup', 'url' => ['/leads/create']],
        ['label' => 'Back', 'url' => ['/leads/back']],
        //['label' => 'Contact', 'url' => ['/site/contact']],
    ];
     
        
        // $menuItems[] = ['label' => 'Login', 'url' => ['/site/login']];
        // $menuItems[] = ['label' => 'About Us', 'url' => ['/site/aboutus']];
        // $menuItems[] = ['label' => 'Contact Us', 'url' => ['/site/contactus']];
        // $menuItems[] = ['label' => 'Terms And Conditions', 'url' => ['/site/terms_and_conditions']];
    
    echo Nav::widget([
        'options' => ['class' => 'navbar-nav navbar-right'],
        'items' => $menuItems,
    ]);
    NavBar::end();
    ?>

    <div class="container">
        <?= Breadcrumbs::widget([
            'links' => isset($this->params['breadcrumbs']) ? $this->params['breadcrumbs'] : [],
        ]) ?>
        <?= Alert::widget() ?>
        <?= $content ?>
    </div>
</div>

<footer class="footer">
    <div class="container">
        <p class="pull-left">&copy; Combtechnologies <?php // = Html::encode(Yii::$app->name) ?> <?= date('Y') ?></p>

        <!-- <p class="pull-right"><?php // Yii::powered() ?></p> -->
    </div>
</footer>

<?php $this->endBody() ?>
</body>
</html>
<?php $this->endPage() ?>
