<?php

/* @var $this \yii\web\View */
/* @var $content string */

use yii\helpers\Html;
use yii\bootstrap5\Nav;
use yii\bootstrap5\NavBar;
use yii\widgets\Breadcrumbs;
use frontend\assets\AppAsset;
use common\widgets\Alert;

AppAsset::register($this);
?>
<?php $this->beginPage() ?>
<!DOCTYPE html>
<html lang="<?= Yii::$app->language ?>">
<head>
    <meta charset="<?= Yii::$app->charset ?>">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <?php $this->registerCsrfMetaTags() ?>
    <!-- <link rel="shortcut icon" href="comb/images/COMB-logo.png" /> -->
    <!-- <link rel="icon" type="image/x-icon" href="comb/images/COMB-logo.png" /> -->
    <title><?= Html::encode($this->title) ?></title>
    <?php $this->head() ?>
    <style>
        .form-control-dark {
  border-color: var(--bs-gray);
}
.form-control-dark:focus {
  border-color: #fff;
  box-shadow: 0 0 0 .25rem rgba(255, 255, 255, .25);
}

.text-small {
  font-size: 85%;
}

.dropdown-toggle:not(:focus) {
  outline: 0;
}

        </style>
</head>
<body>
<?php $this->beginBody() ?>

<div class="wrap">

<?php
if(!Yii::$app->user->isGuest)
{
NavBar::begin([
        //'brandLabel' => Yii::$app->name,
        'brandLabel' => 'Sisems 1.1',
       // 'brandUrl' => Yii::$app->homeUrl,
        'brandUrl' => 'https://sisems.com/',
        'options' => [
            'class' => 'navbar-inverse navbar-fixed-top',
        ],
    ]);
    $menuItems = [
       // ['label' => 'Home', 'url' => ['/site/index']],
       // ['label' => 'About', 'url' => ['/site/about']],
        //['label' => 'Contact', 'url' => ['/site/contact']],
    ];
    if (Yii::$app->user->isGuest) {
        
     //   $menuItems[] = ['label' => 'Login', 'url' => ['/site/login']];
       $menuItems[] = ['label' => 'Signup', 'url' => ['/site/selfregister_signup']];
    //     $menuItems[] = ['label' => 'About Us', 'url' => ['/site/aboutus']];
    //     $menuItems[] = ['label' => 'Contact Us', 'url' => ['/site/contactus']];
    //     $menuItems[] = ['label' => 'Terms And Conditions', 'url' => ['/site/terms_and_conditions']];
        
    } 
    else if(!(Yii::$app->user->isGuest) && Yii::$app->user->identity->username == 'superadmin') {
        $menuItems[] = ['label' => 'Signup', 'url' => ['/site/signup']];
    	
       // $menuItems[] = ['label' => 'Client List', 'url' => ['/user-subscription/index'] ];
       // $menuItems[] = ['label' => 'Signup List', 'url' => ['/leads/index'] ];
        //$menuItems[] = ['label' => 'Profile', 'url' => ['/site/updateprofile','id'=>Yii::$app->user->id] ];
        $menuItems[] = '<li>'
            . Html::beginForm(['/site/logout'], 'post')
            . Html::submitButton(
                'Logout (' . Yii::$app->user->identity->username . ')',
                ['class' => 'btn btn-link logout']
            )
            . Html::endForm()
            . '</li>';
    }
    else if(!(Yii::$app->user->isGuest) && Yii::$app->user->identity->username != 'superadmin' ){
    $menuItems[] = ['label' => 'Profile', 'url' => ['/site/updateprofile','id'=>Yii::$app->user->id] ];
        $menuItems[] = '<li>'
            . Html::beginForm(['/site/logout'], 'post')
            . Html::submitButton(
                'Logout (' . Yii::$app->user->identity->username . ')',
                ['class' => 'btn btn-link logout']
            )
            . Html::endForm()
            . '</li>';
     }
    echo Nav::widget([
        'options' => ['class' => 'navbar-nav navbar-right'],
        'items' => $menuItems,
    ]);
    NavBar::end();
}
    ?>
  <div class="b-example-divider"></div>
  <header class="d-flex flex-wrap justify-content-center py-3 mb-4 border-bottom"  style="background-image: linear-gradient(135deg,rgb(7,1,143) 0%,rgb(132,4,206) 100%)">
      <a href="https://sisems.com/" class="d-flex align-items-center mb-3 mb-md-0 me-md-auto link-body-emphasis text-decoration-none">
      <img width="120" height="40" src="img/sisLogo.png" class="custom-logo" alt="" decoding="async" loading="lazy"  sizes="(max-width: 120px) 100vw, 120px">
       
      </a>

      <ul class="nav nav-pills">
      <li><a href="http://sisems.com/" class="nav-link px-2 text-white">Home</a></li>
      <li><a href="http://sisems.com/#about" class="nav-link px-2 text-white">About</a></li>
          <li><a href="http://sisems.com/#services" class="nav-link px-2 text-white">Services</a></li>
          <li><a href="http://sisems.com/price" class="nav-link px-2 text-white">Pricing</a></li>
          <li><a href="http://sisems.com/#faq" class="nav-link px-2 text-white">FAQs</a></li>
         
      </ul>
    </header>

  
    <div class="container">
        <?php
        if(!Yii::$app->user->isGuest)
        {
         echo Breadcrumbs::widget([
            'links' => isset($this->params['breadcrumbs']) ? $this->params['breadcrumbs'] : [],
         ]);
         }?>
        <?= Alert::widget() ?>
        <?= $content ?>
    </div>
</div>

<footer class="footer">
    <div class="container">
        <p class="pull-left">&copy; Sisems <?php // = Html::encode(Yii::$app->name) ?> <?= date('Y') ?></p>

        <!-- <p class="pull-right"><?php // Yii::powered() ?></p> -->
    </div>
</footer>

<?php $this->endBody() ?>
</body>
</html>
<?php $this->endPage() ?>

