<?php

use yii\helpers\Html;
use yii\grid\GridView;
use common\models\User;

/* @var $this yii\web\View */
/* @var $searchModel frontend\models\UserSubscriptionSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = 'User Subscriptions';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="user-subscription-index">

    <h1><?= Html::encode($this->title) ?></h1>
    <?php // echo $this->render('_search', ['model' => $searchModel]); ?>

   <!--  <p>
        <? Html::a('Create User Subscription', ['create'], ['class' => 'btn btn-success']) ?>
    </p> -->

    <?= GridView::widget([
        'dataProvider' => $dataProvider,
        'filterModel' => $searchModel,
        'columns' => [
            ['class' => 'yii\grid\SerialColumn'],

            //'id',
           // 'user_id',
            //'subscription_id',
            [
                'label' => 'User Name',
                'value' => function($item){
              return $item->getuserName($item->user_id);
          
            },
                
            ],
            [
                'label' => 'Organization Name',
                'value' => function($item){
              return $item->getuserOrgnizationName($item->user_id);
          
            },
                
            ],
            [
                'label' => 'Subscription Name',
                'attribute' => 'subscriptionName.subscription_name',
                
            ],
            [
              'label' => 'Contact No.',
              'value' => function($item){
                $contact=User::findOne($item->user_id);
                return $contact->contact_no;
            //return $item->getuserName($item->user_id);
        
          },
              
          ],
             'date',
            'expiry_date',
            //'status',
            //'payment_status',
            //'created_at',
            //'updated_at',
            ['attribute'=>'url',
             'label'=>'Application Access Url',
              'content'=>
                function($data)
                {
                    //var_dump($data);
                    $organization_name=$data->getuserOrgnizationName($data->user_id);
                    $Organization = substr($organization_name, 0, 4);
                
                      $Organization = preg_replace('/\s+/', '', $Organization);

                    return '<a target="_blank" href="http://combtechnologies.com/'.$Organization.'_'.$data->user_id.'/index.php?r=site%2Flogin">http://combtechnologies.com/'.$Organization.'_'.$data->user_id.'/index.php?r=site%2Flogin</a>';
                }
                
                ],

            // ['class' => 'yii\grid\ActionColumn'],
        ],
    ]); ?>
</div>
