<?php
namespace frontend\controllers;

use frontend\models\ResendVerificationEmailForm;
use frontend\models\VerifyEmailForm;
use Yii;
use yii\base\InvalidArgumentException;
use yii\web\BadRequestHttpException;
use yii\web\HeadersAlreadySentException;
use yii\web\Controller;
use yii\filters\VerbFilter;
use yii\filters\AccessControl;
use common\models\LoginForm;
use frontend\models\PasswordResetRequestForm;
use frontend\models\ResetPasswordForm;
use frontend\models\SignupForm;
use frontend\models\ContactForm;
use yii\web\UploadedFile;
use common\models\User;
use yii\web\NotFoundHttpException;
use frontend\models\UserSubscription;
use frontend\models\PaymentData;
use frontend\models\CustomerDataForm;
use frontend\models\RenewForm;
use frontend\models\Subscription;
use frontend\models\CouponCodes;
use frontend\models\MobileOtp;

/**
 * Site controller
 */

class SiteController extends Controller
{
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'access' => [
                'class' => AccessControl::className(),
                'only' => ['logout', 'signup','selftregister_signup'],
                'rules' => [
                    [
                        'actions' => ['selftregister_signup'],
                        'allow' => true,
                        'roles' => ['?'],
                    ],
                    [
                        'actions' => ['logout','signup','selftregister_signup'],
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                ],
            ],
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'logout' => ['post'],
                ],
            ],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function actions()
    {
        return [
            'error' => [
                'class' => 'yii\web\ErrorAction',
            ],
            'captcha' => [
                'class' => 'yii\captcha\CaptchaAction',
               // 'fixedVerifyCode' => YII_ENV_TEST ? 'testme' : null,
            ],
        ];
    }

    /**
     * Displays homepage.
     *
     * @return mixed
     */
    public function actionIndex()
    {
        return $this->render('index'); 
    }
  public function actionIndex_new()
    {
        $this->layout = "comb";
        return $this->render('index_new'); 
    }

    /**
     * Logs in a user.
     *
     * @return mixed
     */
    public function actionLogin()
    {
        if (!Yii::$app->user->isGuest) 
        {
            return $this->goHome();
        }

        $model = new LoginForm();
        if ($model->load(Yii::$app->request->post()) && $model->login()) {
            return $this->goBack();
        } else {
            $model->password = '';

            return $this->render('login', [
                'model' => $model,
            ]);
        }
    }

    /**
     * Logs out the current user.
     *
     * @return mixed
     */
    public function actionLogout()
    {
        Yii::$app->user->logout();

        return $this->goHome();
    }

    /**
     * Displays contact page.
     *
     * @return mixed
     */
    public function actionContact()
    {
        $model = new ContactForm();
        if ($model->load(Yii::$app->request->post()) && $model->validate()) {
            if ($model->sendEmail(Yii::$app->params['adminEmail'])) {
                Yii::$app->session->setFlash('success', 'Thank you for contacting us. We will respond to you as soon as possible.');
            } else {
                Yii::$app->session->setFlash('error', 'There was an error sending your message.');
            }

            return $this->refresh();
        } else {
            return $this->render('contact', [
                'model' => $model,
            ]);
        }
    }

    /**
     * Displays about page.
     *
     * @return mixed
     */
    public function actionAbout()
    {
        echo "hi";
       
        exit;

        return $this->render('about');
    }
   public function actionAbout_new()
    {
        $this->layout = "comb";
        return $this->render('about_new'); 
    }
    
     public function actionFeature()
    {
        $this->layout = "comb";
        return $this->render('feature'); 
    }
    /**
     * Signs user up.
     *
     * @return mixed
     */
    public function actionSignup()
    {
    	exit;
        
        $model = new SignupForm();
        
        if ($model->load(Yii::$app->request->post())) 
            {
            if ($user = $model->signup()) {
                
                $user_data = User::findOne($user->id); 
                //echo $model->password;
                $file =  UploadedFile::getInstance($model, 'imageFile'); // Get File Object byName
                
                if($file)
                {
                    $user_data->imagePath='upload/'.'logo_'.$user->id . '.' . $file->extension;
                }
                else
                {
                    $user_data->imagePath='';
                }
                $new_pass='';
                $new_pass=$this::generateStrongPassword();
                $user_data->setPassword($new_pass);
                $user_data->password= $new_pass;
                if(!$user_data->save()){
                    var_dump($user_data->errors);
                    exit;
                }
            
                $model->imageFile = UploadedFile::getInstance($model, 'imageFile');
               // $image=file_get_contents($model->imageFile->tempName);  
                $image='';
                $model->upload($user->id);
            
                $user_subscription = new UserSubscription();
                $user_subscription->user_id=$user->id;
                $user_subscription->subscription_id=$user->subscription_type;
                // $user_subscription->status=1;
                //$subscription_duration = $model->subscription_duration;
                date_default_timezone_set("Asia/Kolkata");
                $current_date = date('Y-m-d H:i:s');
                $user_subscription->date = $current_date;
           
          if(!$user_subscription->save()){
                    var_dump($user_subscription->errors);
                    exit;
                }
                 // mkdir('/home/combtechnologies/public_html/$user->organization_name', 0777, true);
                $dirname = substr($user->organization_name, 0, 4);
                
                $dirname = preg_replace('/\s+/', '', $dirname);
                
                $dirname = $dirname.'_'.$user->id;
                
                $user_data->database_name= $dirname;
               
                 $user_data->save();

                symlink(Yii::$app->params["symlink_folder"], Yii::$app->params["symlink_link"].$dirname);
          $databasename="sisems_".$dirname;
          $connection = Yii::$app->getDb();
            $command = $connection->createCommand("CREATE DATABASE ".$databasename);
           
           //     $command->execute();
    
                $mysqlImportFilename =Yii::$app->params['sqlfilepath'];
                        
               $command_import="php81 /home/sisems/public_html/i1/school-web/artisan migrate --schema=".$databasename ;
               
               $output=array();
             //   exec($command_import,$output,$worked);
           
                /// Insert profile data into new db profile table ///
                $user_name= $connection->username;
                $password=$connection->password;
                $con = mysqli_connect(Yii::$app->params['ip'],"$user_name","$password","$databasename");
                if (!$con)
                {
                    echo "Failed to connect to MySQL: " . mysqli_connect_error();
                }
             
                //$sql="insert into profile(name,address,contact,logo,sms_gateway_key,gst_no,gst_per,email_id,gst_status,fine_day_status,subscription_id,subscription_user_id,product_selection_flag) values('$user->organization_name','$user->address','$user->contact_no','$image','$user->sms_key','$user->gst_no','$gst_percent','$user->email','1','$fine_day_status','$user->subscription_type','$user->id','$product_selection_flag')";                
                $sql="insert into profile(user_id,create_time,full_name) values('$user->id','$current_date','$user->organization_name',)";                
                $result=mysqli_query($con,$sql);
                //update college info 
                $sql_college_info="UPDATE college_info SET name='$user->organization_name',address='$model->address',contact_no='$model->contact_no' WHERE college_id=1"; 
                mysqli_query($con,$sql_college_info);
                // update password and email 
               // $encrypted_password=sha1($model->password);
                $sql1="UPDATE user SET `password`='$model->password_hash',email='$model->email' WHERE id=1"; //`pass`='$model->password',
                mysqli_query($con,$sql1);
                
             
          	//$this->sendEmail($user);
                return $this->goHome();
            }
        }
        return $this->render('signup', [
            'model' => $model,
        ]);
 }
    
    
    public function actionUpdateprofile($id)
    {
        $model = $this->findModel($id);
           $singup_model = new SignupForm();
           $x = Yii::$app->request->post();
           isset($x['User'])?$x['SignupForm']= $x['User']:'';
           unset($x['User']);
           
        
        if ($model->load(Yii::$app->request->post()) ) {
            
            $singup_model->load($x);
            
             if ($user = $singup_model ->updatesignup($id)) {
              
            $user_data = User::findOne($id); 
             
            $file =  UploadedFile::getInstance($model, 'imageFile'); // Get File Object byName
          
            if($file){
                    if(isset($model->imagePath)) {
                   unlink($model->imagePath);
                }
                $user_data->imagePath='upload/'.'logo_'.$id . '.' . $file->extension;
            }
           /* else{
                $user_data->imagePath='';
            }*/

           if(! $user_data->save()){
                var_dump( $user_data->errors);
                exit;
            }
               
             $model->imageFile = UploadedFile::getInstance($model , 'imageFile');
            $singup_model->upload($id);
           
            return $this->goHome();
             }
        } 
       
         /*$sub= UserSubscription::find() ->one(); */
                       
         return $this->render('updateProfile', [
                'model' => $model,
                // 'model1' => $sub,
            ]);
        
    }

 protected function sendEmail($user)
    {
        
      $email = Yii::$app
            ->mailer
            ->compose(
                ['html' => 'emailVerify-html', 'text' => 'emailVerify-text'],
                ['user' => $user]
            )
            ->setFrom(['support@sisems.com'=>'SisEMS Registration']) //[Yii::$app->params['supportEmail'] => Yii::$app->name . ' robot']
            ->setTo($user->email)
            ->setSubject('Sisems Applications Access Deatials - ' .$user->organization_name ) //Yii::$app->name
            ->send();
            if($email){
              Yii::$app->session->setFlash('success', 'Thank you for registration. Please check your inbox for verification email.');
              }
              else{
              Yii::$app->getSession()->setFlash('warning','Failed, contact Admin!');
              }
                 
        
    }
    /**
     * Requests password reset.
     *
     * @return mixed
     */
    public function actionRequestPasswordReset()
    {
        $model = new PasswordResetRequestForm();
        if ($model->load(Yii::$app->request->post()) && $model->validate()) {
            if ($model->sendEmail()) {
                Yii::$app->session->setFlash('success', 'Check your email for further instructions.');

                return $this->goHome();
            } else {
                Yii::$app->session->setFlash('error', 'Sorry, we are unable to reset password for the provided email address.');
            }
        }

        return $this->render('requestPasswordResetToken', [
            'model' => $model,
        ]);
    }
    

    /**
     * Resets password.
     *
     * @param string $token
     * @return mixed
     * @throws BadRequestHttpException
     */
    public function actionResetPassword($token)
    {
        try {
            $model = new ResetPasswordForm($token);
        } catch (InvalidArgumentException $e) {
            throw new BadRequestHttpException($e->getMessage());
        }

        if ($model->load(Yii::$app->request->post()) && $model->validate() && $model->resetPassword()) {
            Yii::$app->session->setFlash('success', 'New password saved.');

            return $this->goHome();
        }

        return $this->render('resetPassword', [
            'model' => $model,
        ]);
    }

    /**
     * Verify email address
     *
     * @param string $token
     * @throws BadRequestHttpException
     * @return yii\web\Response
     */
    public function actionVerify($token)
    {
        try {
            $model = new VerifyEmailForm($token);
        } catch (InvalidArgumentException $e) {
            throw new BadRequestHttpException($e->getMessage());
        }

        if ($user = $model->verifyEmail()) {
            
                Yii::$app->session->setFlash('success', 'Your email has been confirmed!');
             
        }else
        Yii::$app->session->setFlash('error', 'Sorry, we are unable to verify your account with provided token.');
        $url= '/i1/'.$user->id.'/public/';
        $app_link = 'https://'.$_SERVER['SERVER_NAME'].$url; ///email_verification.php?token='.$user->verification_token;
     
        return $this->render('mail_verified', [
            'model' => $model,
            'app_link'=>$app_link,
        ]);
    }

    /**
     * Resend verification email
     *
     * @return mixed
     */
    public function actionResendVerificationEmail()
    {
        $model = new ResendVerificationEmailForm();
        if ($model->load(Yii::$app->request->post()) && $model->validate()) {
            if ($model->sendEmail()) {
                Yii::$app->session->setFlash('success', 'Check your email for further instructions.');
                return $this->goHome();
            }
            Yii::$app->session->setFlash('error', 'Sorry, we are unable to resend verification email for the provided email address.');
        }

        return $this->render('resendVerificationEmail', [
            'model' => $model
        ]);
    }
    
    protected function findModel($id)
    {
        if (($model = User::findOne($id)) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }
    // code added by chaitany.
    //  function checks email
    public function actionCheckemail($email)
    {
                //echo "In check email function,<br>email=".$email;
                if($email!=null)
                {
               // echo "checking email is null or not ?";
                    $sql="select * from user where email='$email'";
                    $post=Yii::$app->db->createCommand($sql)->queryOne();
                    if(isset($post['email'])!=0)
                    {
                        return 1;
                    }
                    else
                    {
                        return 0;
                    }
                }
    }
   // code added by chaitanya
   // function checks username.
    public function actionCheckusername($username)
    {
                //echo "In check username function,<br>username=".$username;
                if($username!=null)
                {
                    //echo "checking username is null or not ?";
                    $sql="select * from user where username='$username'";
                    $post=Yii::$app->db->createCommand($sql)->queryOne();
                    //echo $sql;
                    if(isset($post['username'])!=0)
                    {
                        return 'success';
                    }
                    else
                    {
                        return 'failure';
                    }
                }
    }
    public function actionAboutus()
    {
        return $this->render('aboutus');
    }
    
    public function actionContactus()
    {
        return $this->render('contactus');
    }
    public function actionTerms_and_conditions()
    {
        $this->layout='combnew';
        return $this->render('terms_and_conditions');
    }
    
    // code added for response handler
    public function actionResponsehandler()
    { 
        $session=Yii::$app->session;
        $id=Yii::$app->user->id;
        function decrypt($encryptedText,$key)
        {
  $key = hextobin(md5($key));
  $initVector = pack("C*", 0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f);
  $encryptedText = hextobin($encryptedText);
  $decryptedText = openssl_decrypt($encryptedText, 'AES-128-CBC', $key, OPENSSL_RAW_DATA, $initVector);
  return $decryptedText;
        }
        
        function hextobin($hexString) 
        { 
  $length = strlen($hexString); 
  $binString="";   
  $count=0; 
  while($count<$length) 
  {       
      $subString =substr($hexString,$count,2);           
      $packedString = pack("H*",$subString); 
      if ($count==0)
      {
      $binString=$packedString;
      } 
      
      else 
      {
      $binString.=$packedString;
      } 
      
      $count+=2; 
            } 
        return $binString; 
        }
        
  $workingKey='6D51EE3A3F5C3556E12AA744259D82BB';   //Working Key should be provided here.
  $encResponse=$_POST["encResp"];     //This is the response sent by the CCAvenue Server
  $rcvdString=decrypt($encResponse,$workingKey);    //Crypto Decryption used as per the specified working key.
  $order_status="";
  $decryptValues=explode('&', $rcvdString);
  $dataSize=sizeof($decryptValues);
        try
        {
        for($i = 0; $i < $dataSize; $i++) 
  {
    $information=explode('=',$decryptValues[$i]);
    if($i==3) $order_status=$information[1];// setting order status
  }
        for($i = 0; $i < $dataSize; $i++) 
  {
    $information=explode('=',$decryptValues[$i]);
                if($i==0)$order_id=urldecode($information[1]);//setting order_id
                if($i==1)$track_id=urldecode($information[1]);//setting track id
                if($i==8)$order_message=urldecode($information[1]);//setting order message
        }
        date_default_timezone_set("Asia/Kolkata");
        $current_date = date('Y-m-d H:i:s'); 
            
        //update order status,track_id,order_status_message
        $sql="update payment_order set order_status='$order_status',track_id='$track_id'
             ,order_status_message='$order_message',
            updated_at='$current_date' where order_id=$order_id";
        $db=Yii::$app->db;
        //echo $sql;
        $db->createCommand($sql)->execute();
        //if status is success
       // $order_status='Success';
        if($order_status=='Success')
        { 
            if($session->has('subscription') && $session->has('duration'))
            {
                $subscription=$session->get('subscription');//getting subscription
                $duration=$session->get('duration');//getting duration
                
                $current_date = date('Y-m-d H:i:s');
                
                    switch($duration)
                    {
                     case 12:
                        $startdate = $current_date;
                        $expiry_date=date('Y-m-d H:i:s', strtotime('+1 year'));
                     break;
                     
                     case 6 :
                        $startdate = $current_date;
                        $expiry_date=date('Y-m-d H:i:s', strtotime('+6 month'));
                     break;
                 
                     case 3:
                        $startdate = $current_date;
                        $expiry_date=date('Y-m-d H:i:s', strtotime('+3 month'));// change done on 14/11/19 by chaitany
                     break;
                    }
                    
                // update subscription status
                    
                $sql3="update user_subscription set
                status=0 where status=1 and user_id=$id";
                $db->createCommand($sql3)->execute();
                
                // insert new record for new subscription
                $sql4="insert into user_subscription 
                (user_id,status,payment_status,subscription_id,date,expiry_date,
                created_at,updated_at) values
                ($id,1,1,$subscription,'$startdate','$expiry_date','$startdate',
                 '$startdate')";
                $db->createCommand($sql4)->execute();
                $session->remove('subscription');// removing subscription from status
                $session->remove('duration');// removing subscription from duration
            }
            else
            {     
                //update payment status 
                 $sql2="update user_subscription set payment_status=1 where
                status=1 and user_id=$id";   
                $db->createCommand($sql2)->execute();
            }
        }
        }
        catch(Exception $e)
        {
            $e->getMessage();
        }
        $session->setFlash('status',$order_status);//setting flash status
        return $this->render('index');   // redirecting to index
    }
    
    // code added for request handler
    public function actionRequesthandler()
    {
        $model=new CustomerDataForm(); // creating object of customer data form
        $arr=(array)$model;// conversion of object into array
     
        $session=Yii::$app->session;
      try
      {
        if(isset($_POST['payment']))
        {
            
        }
        else
        {
             $type=$_POST['RenewForm']['subscription_type'];
             $duration=$_POST['RenewForm']['subscription_duration'];
             $session->set('subscription',$type);
             $session->set('duration',$duration);
        } 
    
        // setting subscription & duration in session.
         
         $id=Yii::$app->user->id;
     
         date_default_timezone_set("Asia/Kolkata");
         $current_date = date('Y-m-d H:i:s'); 
     
         //inserting into payment order table
         //var_dump($model);
         $order_id=$model->order_id;
         $amount=$model->amount;
         $sql2="insert into payment_order (order_id,track_id,amount,user_id,created_at,updated_at)
              values('$order_id',0,'$amount','$id','$current_date','$current_date')";
     
        Yii::$app->db->createCommand($sql2)->execute();
      }
      catch (Exception $ex) 
      {
         var_dump($ex->getMessage());
         exit();
      }
   
      return $this->render('requesthandler',['model'=>$arr]);
     }
    
    // code added for chekout page
    public function actionCheckout()
    {
       // echo 'action checkout';
        return $this->render('checkout'); 
    }
    
    public function beforeAction($action)
    {            
        if ($action->id == 'responsehandler') 
        {
        $this->enableCsrfValidation = false;
        }
        return parent::beforeAction($action);
    }

    public function actionUpdatepayment()
    {
        $orderid=$_POST['orderid'];
        $orderstatus=$_POST['orderstatus'];
        $ordermessage=$_POST['ordermessage'];
        //echo $orderid.$orderstatus.$ordermessage;
            date_default_timezone_set("Asia/Kolkata");
            $current_date = date('Y-m-d h:i:s'); 
            
        $sql="update payment_order set order_status='$orderstatus'
             ,order_status_message='$ordermessage',updated_at='$current_date' where order_id=$orderid";
        $db=Yii::$app->db;
        //echo $sql;
        $db->createCommand($sql)->execute();
      
        if($orderstatus=='Success')
        {        
         $user=Yii::$app->user->identity->username;
         $sql2="update user_subscription set payment_status=1 where status=1 and user_id in
               (select id from user where username='$user')";   
         $db->createCommand($sql2)->execute();
         $session=Yii::$app->session;
            if($session->has('subscription') && $session->has('duration'))
            {
                $subscription=$session->get('subscription');
                $duration=$session->get('duration');
                
                $current_date = date('Y-m-d h:i:s');
                    switch($duration)
                    {
                     case 12:
                        $startdate = $current_date;
                        $expiry_date=date('Y-m-d h:i:s', strtotime('+1 year'));
                     break;
                     
                     case 6 :
                        $startdate = $current_date;
                        $expiry_date=date('Y-m-d h:i:s', strtotime('+6 month'));
                     break;
                 
                     case 1:
                        $startdate = $current_date;
                        $expiry_date=date('Y-m-d h:i:s', strtotime('+1 month'));
                     break;
                    }
                $sql3="update user_subscription set
                status=0 where status=1 and user_id
                in(select id from user where username='$user')";
                $db->createCommand($sql3)->execute();
                
                $sql4="insert into user_subscription 
                (user_id,status,payment_status,subscription_id,date,expiry) values
                (user_id,1,1,$subscription,'$startdate','$expiry_date') where user_id
                 in (select id from user where username='$user')";
                $db->createCommand($sql4)->execute();
                $session->remove('subscription');
                $session->remove('duration');
            }
        }
    }
        //task : renewal form that takes values from one model
    
    public function actionRenew()
    {
        $model=new RenewForm();
        
        return $this->render('renew',['model1'=>$model]);
    }
    public function actionGetsubscriptionprice($subscription_type)
    {
        if(!empty($subscription_type))
        {
          $result_price= Subscription::find()->Where(['=','id',$subscription_type])->One();
         $result= '<table  border="1"><tr ><th style="padding:5px;border:1px solid black; text-align:center;">Year Price</th><th style="padding:5px;border:1px solid black; text-align:center;">Half Year Price</th><th style="padding:5px;border:1px solid black; text-align:center;">Three Months</th></tr>';
         $result.= '<tr ><td style="padding:5px;border:1px solid black; text-align:center;">'.$result_price->year_price.'</td><td style="padding:5px;border:1px solid black; text-align:center;">'.$result_price->half_year_price.'</td><td style="padding:5px;border:1px solid black; text-align:center;">'.$result_price->month_price.'</td></tr></table>';
        return $result;
        }

    }

    ///////////////////// Self Register - Signup form ///////////////

    public function actionSelfregister_signup()
    {
       // $this->layout="combnew";
       
       $app_down=0;
       //exit;
       
        // Storing name in $name variable
   
        
        $model = new SignupForm();
        
        if ($model->load(Yii::$app->request->post())) 
            {
         //  $verify_OTP=0; 	
      $mobile_no=$model->contact_no;
      $mobile_otp=Yii::$app->request->post('mobile_otp');
           
      $today_date=date('Y-m-d');
        if ($model->validate()) {
        $verify_OTP=MobileOtp::find()->Where(['=','otp',$mobile_otp])
                ->andWhere(['=','mobile_no',$mobile_no])
                ->andWhere(['=','date',$today_date])->all(); 
     
        if(count($verify_OTP) > 0 )
        {
            
            	
    
    // Storing google recaptcha response
    // in $recaptcha variable
    $recaptcha = $_POST['g-recaptcha-response'];
  
    // Put secret key here, which we get
    // from google console
    $secret_key = '6LcCW8UlAAAAAKyW-vko4O7qYaV8iPtLDIawaxcc';
  
    // Hitting request to the URL, Google will
    // respond with success or error scenario
    $url = 'https://www.google.com/recaptcha/api/siteverify?secret='
          . $secret_key . '&response=' . $recaptcha;
  
    // Making request to verify captcha
    $response = file_get_contents($url);
  
    // Response return by google is in
    // JSON format, so we have to parse
    // that json
    $response = json_decode($response);
  
    // Checking, if response is true or not
    if ($response->success == true) {
    
               
                if ($user = $model->signup()) {
                
                    $user_data = User::findOne($user->id); 
                    //echo $model->password;
                    $file =  UploadedFile::getInstance($model, 'imageFile'); // Get File Object byName
                    
                    if($file)
                    {
                        $user_data->imagePath='upload/'.'logo_'.$user->id . '.' . $file->extension;
                    }
                    else
                    {
                        $user_data->imagePath='';
                    }
                   
                    $new_pass=$this::generateStrongPassword();
                    $user_data->setPassword($new_pass);
                    $user_data->password= $new_pass;
                    $ip="-";
							if(!empty($_SERVER['HTTP_CLIENT_IP'])) {  
          			      $ip = $_SERVER['HTTP_CLIENT_IP'];  
    				    }  
 						   //whether ip is from the proxy  
  							  elseif (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {  
               			 $ip = $_SERVER['HTTP_X_FORWARDED_FOR'];  
   									  }  
						//whether ip is from the remote address  
    				else{  
             		$ip = $_SERVER['REMOTE_ADDR'];  
     				}
     				$user_data->ip_address=$ip;    
     				$user_data->user_agent=$_SERVER['HTTP_USER_AGENT'];                  
          
                    if(!$user_data->save()){
                        var_dump($user_data->errors);
                        exit;
                    } 
                    
          
                
                    $model->imageFile = UploadedFile::getInstance($model, 'imageFile');
                   // $image=file_get_contents($model->imageFile->tempName);  
                    $image='';
                    $model->upload($user->id);
                
                    $user_subscription = new UserSubscription();
                    $user_subscription->user_id=$user->id;
                    $user_subscription->subscription_id=$user->subscription_type;
                    // $user_subscription->status=1;
                    //$subscription_duration = $model->subscription_duration;
                    date_default_timezone_set("Asia/Kolkata");
                    $current_date = date('Y-m-d H:i:s');
                    $user_subscription->date = $current_date;
                   
              if(!$user_subscription->save()){
                        var_dump($user_subscription->errors);
                        exit;
                    }
                      
                    
                    $user_data->database_name= $user->id; //$dirname;
                     
                     $user_data->save();
    
              if($app_down==0)
                  {
                     symlink(Yii::$app->params["symlink_folder"], Yii::$app->params["symlink_link"].$user->id); //$dirname
           
                     $databasename="sisems_".$user->id; //$dirname
              			$connection = Yii::$app->getDb();
              			$command = $connection->createCommand("CREATE DATABASE ".$databasename);
                     $command->execute();
        
               
                   
                    $command_import="php81 /home/sisems/i3_sisems_com/school-web/artisan migrate --schema=".$databasename;
                	  exec($command_import,$output,$worked);
                  
                
                    /// Insert profile data into new db profile table ///
                    $user_name= $connection->username;
                    $password=$connection->password;
                    $con = mysqli_connect(Yii::$app->params['ip'],"$user_name","$password","$databasename");
                    //$con = mysqli_connect("localhost","$user_name","$password","$databasename"); // For Production 
                     //$con = mysqli_connect("192.168.1.72","$user_name","$password","$databasename");
                    // Check connection
                    if (!$con)
                    {
                        echo "Failed to connect to MySQL: " . mysqli_connect_error();
                    }
                   
                    $hash = Yii::$app->getSecurity()->generatePasswordHash($new_pass);
                    $sql="insert into users(name,email,password,utype,role_id) 
                    values('admin','$user->email','$hash','ADM',1)";                
                    $result=mysqli_query($con,$sql);

                    
                    
                    //update college info 
                    $sql_college_info="insert into college_infos(name,address,contact_no,profile_id	) values('$user->organization_name','$model->address','$model->contact_no','$user->id')"; 
                    mysqli_query($con,$sql_college_info);
                    
                    $user=  User::findOne($user->id); 
					          
                   
                    $this->sendEmail($user);
          
      		    }
          // Send Notification to admin - on Whatsapp //
          /*  $sendMsg="New user has registerd successfully on combtechnologies site. \r\n Details - \r\n Person Name -".$user->first_name."\r\n Salon Name- ".$user->organization_name."\r\n Address - ".$user->address."\r\n Email Id- ".$user->email."\r\nContact No- ".$user->contact_no;
            $whatsapp_key="60f8290c6ac9583c92671188";  // Petal touch whatsapp key
            $admin_contact_no="9850411116"; // Sachin Kale contact No. 9850411116
            $this->sendWhatsapp($sendMsg, $whatsapp_key, $admin_contact_no);
               */
                    
          $url='https://sisems.com/message/'; //http://sisems.com/index_successmsg.html
          return $this->redirect($url);
                //return $this->goHome();
            }
         }  else {
         	Yii::$app->session->setFlash('warning', "Please check captcha");
         }
       }else {
			Yii::$app->session->setFlash('warning', "Invalid OTP");
       }
	         
	          }else {
     	 
     
     $err_array = array_values($model->errors);
   //  var_dump($err_array);
     
     Yii::$app->session->setFlash('warning', $err_array[0]); 
     //exit;
     }
    
         
         
        }
        return $this->render('selfregister_signup', [
            'model' => $model,
        ]);
 }

    function generateStrongPassword($length = 6, $add_dashes = false, $available_sets = 'luds')
    {
        $sets = array();
        if(strpos($available_sets, 'l') !== false)
            $sets[] = 'abcdefghjkmnpqrstuvwxyz';
        if(strpos($available_sets, 'u') !== false)
            $sets[] = 'ABCDEFGHJKMNPQRSTUVWXYZ';
        if(strpos($available_sets, 'd') !== false)
            $sets[] = '23456789';
        if(strpos($available_sets, 's') !== false)
            $sets[] = '!@#$%&*?';
        $all = '';
        $password = '';
        foreach($sets as $set)
        {
            $password .= $set[array_rand(str_split($set))];
            $all .= $set;
        }
        $all = str_split($all);
        for($i = 0; $i < $length - count($sets); $i++)
            $password .= $all[array_rand($all)];
        $password = str_shuffle($password);
        if(!$add_dashes)
            return $password;
        $dash_len = floor(sqrt($length));
        $dash_str = '';
        while(strlen($password) > $dash_len)
        {
            $dash_str .= substr($password, 0, $dash_len) . '-';
            $password = substr($password, $dash_len);
        }
        $dash_str .= $password;
        return $dash_str;
    }
    public function sendWhatsapp($message,$whatsapp_key,$admin_contact_no)
    {
         $curl = curl_init();
       //  echo "doing curl call <br/>";
     $whatsapp_url="https://apiwhatsapp.transgosms.com/api/sendText?token=$whatsapp_key&phone=91".$admin_contact_no."&message=". urlencode($message);

curl_setopt_array($curl, array(
  CURLOPT_URL => $whatsapp_url,
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_ENCODING => "",
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 30,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => "GET",
 
));

$response = curl_exec($curl);
$err = curl_error($curl);
// echo "done curl call <br/> res: $response <br/>";
curl_close($curl);

if ($err) {
  return "cURL Error #:" . $err;
} else {
  return $response;
}
    }
    //public function actionSend_mobile_otp($sms_key,$mobile_numbers)
    public function actionSend_mobile_otp($mobile_number,$school_name,$captcha) //,$sendMsg,$sms_provider_id
    {
          // in $recaptcha variable
  //  $recaptcha = $_POST['g-recaptcha-response'];
  
    // Put secret key here, which we get
    // from google console
    $secret_key = '6LcCW8UlAAAAAKyW-vko4O7qYaV8iPtLDIawaxcc';
  
    // Hitting request to the URL, Google will
    // respond with success or error scenario
    $url = 'https://www.google.com/recaptcha/api/siteverify?secret='
          . $secret_key . '&response=' . $captcha;
  
    // Making request to verify captcha
    $response = file_get_contents($url);
  
    // Response return by google is in
    // JSON format, so we have to parse
    // that json
    $response = json_decode($response);
  
    // Checking, if response is true or not
    if ($response->success == true) {
   
        \Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;
        $apiKey = urlencode('NDQ2ZTMxNTU1YTYzNTU0ZjUzNzAzNzUxNGQ1YTQzNzI=');
        $rand_number=str_pad(rand(100000,999999), 6, "0", STR_PAD_LEFT);
        $mobile_no= "91".$mobile_number;
        $current_date= date('Y-m-d');
        // check alerady registered user//
        $existUser=User::find()->Where(['=','contact_no',$mobile_number])->all();
       
        // check OTP count - send to mobile no.//
        $send_otp_count=MobileOtp::find()->Where(['=','mobile_no',$mobile_number])
                         ->andWhere(['=','date',$current_date])->all();
      
         
         $sendOtbcnt= count($send_otp_count);
        if(count($existUser) > 0)
        {
            return array('code'=>0,'error_msg'=>'Already registered user ');
           
        }
        else if( $sendOtbcnt == '3'){
            return array('code'=>0,'error_msg'=>'Already send OTP to mobile number');
            
        }
        else{
           
            $mobile_otp = new MobileOtp();
            $mobile_otp->mobile_no=$mobile_number;
            $mobile_otp->school_name=$school_name;
            $mobile_otp->date=$current_date;
            $mobile_otp->otp=$rand_number;
            $mobile_otp->save(false);
           
        // Message details
        $numbers = array($mobile_no);
        $sender = urlencode('COLPVT');
        $message = rawurlencode($rand_number.' is the OTP to validate your registration with Coalesceflow Pvt. Ltd.. The OTP is valid for 20 minutes.');
     
        $numbers = implode(',', $numbers);
     
        // Prepare data for POST request
        $data = array('apikey' => $apiKey, 'numbers' => $numbers, "sender" => $sender, "message" => $message);
     
        // Delebratly commented following code. Uncomment on production 

       /**/
        $ch = curl_init('https://api.textlocal.in/send/');
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $response = curl_exec($ch);
        curl_close($ch);
        return $response;

return array('code'=>1);
}
    }
exit;
        
           
    }


public function actionOTP()
{
    echo "hi";
    exit;
    $model = new ContactForm();
    if ($model->load(Yii::$app->request->post()) && $model->validate()) {
        if ($model->sendEmail(Yii::$app->params['adminEmail'])) {
            Yii::$app->session->setFlash('success', 'Thank you for contacting us. We will respond to you as soon as possible.');
        } else {
            Yii::$app->session->setFlash('error', 'There was an error sending your message.');
        }

        return $this->refresh();
    } else {
        return $this->render('contact', [
            'model' => $model,
        ]);
    }
}



function hextorgb ($hexstring){
    $integar = hexdec($hexstring);
    return array("red" => 0xFF & ($integar >> 0x10),
                 "green" => 0xFF & ($integar >> 0x8),
                 "blue" => 0xFF & $integar);
                 }

}
