<?php
namespace frontend\models;

use Yii;
use yii\base\Model;
class CustomerDataForm extends Model
{
    public $merchant_id=234878;
    public $order_id;
    public $amount;
    public $currency='INR';
    public $redirect_url='https://combtechnologies.com/subscription/frontend/web/index.php?r=site%2Fresponsehandler';
    public $cancel_url='https://combtechnologies.com/subscription/frontend/web/index.php?r=site%2Fresponsehandler';
    public $language='EN';
    
    public function rules()
    {
        return 
        [
            [['order_id','amount','merchant_id'],'integer'],
            [['currency','redirect_url','cancel_url','language'],'string'],
          
        ];
    }    
    public function __construct()
    {
        //getting time in milliseconds
        $time_milli = (int) round(microtime(true) * 1000);
        
           $this->order_id=$time_milli;
           $this->amount=1;
                   //$this->getAmount();
    }
    
    public function getAmount()
    {        
        $user=Yii::$app->user->id;

        $sql="SELECT TIMESTAMPDIFF(MONTH,us.date,us.expiry_date)
         as 'subscription_duration',us.subscription_id, s.year_price,s.half_year_price,s.month_price  FROM `user_subscription`
         as us inner join user as u on us.user_id=u.id INNER JOIN subscription s ON us.subscription_id = s.id  where u.id='$user'
         and us.status=1";
       
        $data=Yii::$app->db->createCommand($sql)->queryOne();
        $duration=$data['subscription_duration'];
        $subscription=$data['subscription_id'];
        $year_price=$data['year_price'];
        $half_year_price=$data['half_year_price'];
        $three_months_price=$data['month_price'];
        
        // task :calculate amount based on subscription_id & subscription_duration
        $amount=0;
        
        switch($subscription)
        {
            case 1:// change
                    if($duration==3)
                     $amount=$three_months_price; // 6000;   
                    if($duration==6)
                     $amount= $half_year_price; // 12000;
                    if($duration==12)
                     $amount=$year_price; // 20000;   
            break;
        
            case 2:
                    if($duration==3)
                     $amount=$three_months_price; // 10500;   
                    if($duration==6)
                     $amount= $half_year_price; // 18000;
                    if($duration==12)
                     $amount= $year_price; //30000;
            break;
        
            case 3:
                    if($duration==3)
                     $amount=$three_months_price; // 15000;   
                    if($duration==6)
                     $amount= $half_year_price; // 27000;
                    if($duration==12)
                     $amount=$year_price; //50000;
            break;
        }
        return $amount;
    }
}

