<?php

namespace frontend\models;

use Yii;

/**
 * This is the model class for table "mobile_otp".
 *
 * @property int $id
 * @property string $mobile_no
 * @property int $otp
 * @property string $school_name
 * @property string $date
 * @property string $created_at
 * @property string $updated_at
 */
class MobileOtp extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'mobile_otp';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['mobile_no', 'otp', 'school_name', 'date'], 'required'],
            [['otp'], 'integer'],
            [['created_at', 'updated_at'], 'safe'],
            [['mobile_no'], 'string', 'max' => 10],
            [['school_name'], 'string', 'max' => 250],
            [['date'], 'string', 'max' => 25],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'mobile_no' => 'Mobile No',
            'otp' => 'Otp',
            'school_name' => 'School Name',
            'date' => 'Date',
            'created_at' => 'Created At',
            'updated_at' => 'Updated At',
        ];
    }
}
