<?php
namespace frontend\models;

use Yii;
use common\models\User;
use app\models\UploadForm;
use yii\base\Model;
use yii\web\UploadedFile;
/**
 * Signup form
 */
class SignupForm extends Model
{
    public $imageFile;
    public $first_name;
    public $last_name;
    public $address;
    public $organization_name;
    public $subscription_type;
    public $subscription_duration;
    public $gst_no;
    public $sms_key;
    public $contact_no;
    public $gst_percent;
    public $username;
    public $email;
   
    public $password;
    public $coupon_code;
    public $branch_name;
    public $captcha;
    public $user_password;
    public $mobile_otp;
    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            

        
            [['imageFile'], 'file', 'skipOnEmpty' => true, 'extensions' => 'png, jpg'],
   
           // ['username', 'trim'],
            //['username', 'required'],
            
            [['first_name'], 'required'],
         
            [['first_name','last_name','address'], 'string'],
           // ['username', 'unique', 'targetClass' => '\common\models\User', 'message' => 'This username has already been taken.'],
            ['username', 'string', 'min' => 2, 'max' => 255],
          
            [['organization_name','email','contact_no'],'required'],
            ['organization_name','string'],
            
            //['subscription_type','required'],
            ['subscription_type','integer'],
            
            // ['subscription_duration','required'],
            ['subscription_duration','integer'],
            
            
            ['contact_no','integer'],
            ['contact_no','string','min'=>10,'max'=>10],
            
           
            ['email', 'trim'],
            
            ['email', 'email'],
            ['email', 'string', 'max' => 255],
            ['email', 'unique', 'targetClass' => '\common\models\User', 'message' => 'This email address has already been taken.'],

           // ['password', 'required'],
            ['password', 'string', 'min' => 6],
             [['password','auth_key'],'safe'],
            
             ['coupon_code', 'string', 'max' => 100],
           
             ['mobile_otp', 'string', 'max' => 255],
        ];
    }

    /**
     * Signs user up.
     *
     * @return User|null the saved model or null if saving fails
     */
  public function upload($id)
    {
        //if ($this->validate()) {
            //var_dump( $id);
           // exit;
            if($this->imageFile){
                
               // $arr= explode(".", $_SERVER['SERVER_NAME']); //btanish.combtech.com
                //$img_name = $arr[0];
                
                
            $this->imageFile->saveAs('upload/'.'logo_'.$id . '.' . $this->imageFile->extension);
            }
            else{
                //echo "Invoice Image not uploaded";
            }
            return true;
//        } else {
//            return false;
//        }
    }
    
    public function signup()
    {
      /* if (!$this->validate()) {
            return null;
        }*/
        $user = new User();
        
        //$user->username = $this->username;
        $user->first_name = $this->first_name;
        //$user->last_name = $this->last_name;
        $user->address=$this->address;
        $user->organization_name=$this->organization_name;
        $user->subscription_type=0; //$this->subscription_type;
        $user->gst_no=$this->gst_no;
        $user->sms_key=$this->sms_key;
        $user->contact_no=$this->contact_no;
        $user->gst_percent=$this->gst_percent;
        $user->email = $this->email;
        $user->coupon_code = $this->coupon_code;
        $user->branch_name = $this->branch_name;
        $user->status = 9;
        //$user->setPassword($this->password);
        $user->generateAuthKey();
        $user->generateEmailVerificationToken();
        //return $user->save() && $this->sendEmail($user);
        return $user->save() ? $user : null;
        

    }
    
    public function updatesignup($id)
    {
        //$user = new User();
         $user_data = User::findOne($id); 
       // var_dump($this->username);
       // exit;
       // $user_data->username = $this->username;
        $user_data->first_name = $this->first_name;
        $user_data->last_name = $this->last_name;
        $user_data->address=$this->address;
        $user_data->organization_name=$this->organization_name;
      //  $user_data->subscription_type=$this->subscription_type;
        $user_data->gst_no=$this->gst_no;
        $user_data->sms_key=$this->sms_key;
        $user_data->contact_no=$this->contact_no;
        $user_data->gst_percent=$this->gst_percent;
      //  $user_data->email = $this->email;
        //$user_data->setPassword($this->password);
        //$user_data->generateAuthKey();
           
        return $user_data->save(false) ? $user_data : null;

    }
    
    
   } 
    

    /**
     * Sends confirmation email to user
     * @param User $user user model to with email should be send
     * @return bool whether the email was sent
     */
    
   

