<?php

namespace frontend\models;

use Yii;

/**
 * This is the model class for table "subscription".
 *
 * @property int $id
 * @property string $subscription_name
 * @property int $year_price sub_value 1
 * @property int $half_year_price sub_value 2
 * @property int $month_price sub_value 3
 * @property string $created_at
 * @property string $updated_at
 */
class Subscription extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'subscription';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['subscription_name'], 'required'],
            [['year_price', 'half_year_price', 'month_price'], 'integer'],
            [['created_at', 'updated_at'], 'safe'],
            [['subscription_name'], 'string', 'max' => 200],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'subscription_name' => 'Subscription Name',
            'year_price' => 'Year Price',
            'half_year_price' => 'Half Year Price',
            'month_price' => 'Month Price',
            'created_at' => 'Created At',
            'updated_at' => 'Updated At',
        ];
    }
}
