<?php

namespace frontend\models;

use Yii;

/**
 * This is the model class for table "user_subscription".
 *
 * @property integer $id
 * @property integer $user_id
 * @property integer $subscription_id
 * @property string $date
 * @property string $expire_date
 * @property integer $subscription_type
 * @property integer $status
 * @property string $created_at
 * @property string $updated_at
 */
class UserSubscription extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'user_subscription';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['user_id'], 'required'],
            [['user_id', 'subscription_id', 'status'], 'integer'],
            [['date', 'expire_date', 'created_at', 'updated_at'], 'safe'],
        ];
        
        
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'user_id' => 'User ID',
            'subscription_id' => 'Subscription ID',
            'date' => 'Date',
            'expire_date' => 'Expire Date',
            'status' => 'Status',
            'created_at' => 'Created At',
            'updated_at' => 'Updated At',
        ];
    }
  public function getSubscriptionName()
     {
        return $this->hasOne(Subscription::className(), ['id' => 'subscription_id']);
    
      }
      public function getUserName($user_id)
     {
 
          $connection = Yii::$app->getDb();
          $query="SELECT first_name, last_name FROM user where id=".$user_id;

        $command = $connection->createCommand($query );
        $result = $command->queryOne();
        
        return $result['first_name'].' '.$result['last_name'];
    
      }
      public function getUserOrgnizationName($user_id)
     {
 
          $connection = Yii::$app->getDb();
          $query="SELECT organization_name FROM user where id=".$user_id;

        $command = $connection->createCommand($query );
        $result = $command->queryOne();
        
        return $result['organization_name'];
    
      }

}
